/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.store.s3;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.StoreException;
import org.craftercms.core.service.Content;

public class S3Content
implements Content {
    protected long lastModified;
    protected long length;
    protected byte[] content;

    public S3Content(S3Object s3Object) {
        this.lastModified = s3Object.getObjectMetadata().getLastModified().getTime();
        this.length = s3Object.getObjectMetadata().getContentLength();
        this.content = new byte[(int)this.length];
        try (S3ObjectInputStream is = s3Object.getObjectContent();){
            IOUtils.readFully((InputStream)is, (byte[])this.content);
        }
        catch (Exception e) {
            throw new StoreException("Error reading S3 item " + s3Object, (Throwable)e);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }
}

