/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.store.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.store.AbstractCachedFileBasedContentStoreAdapter;
import org.craftercms.engine.store.s3.S3Content;
import org.craftercms.engine.store.s3.S3Context;
import org.craftercms.engine.store.s3.S3File;
import org.craftercms.engine.store.s3.S3Prefix;
import org.craftercms.engine.store.s3.util.S3ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class S3ContentStoreAdapter
extends AbstractCachedFileBasedContentStoreAdapter
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(S3ContentStoreAdapter.class);
    public static final String DELIMITER = "/";
    protected S3ClientBuilder clientBuilder;
    protected AmazonS3 client;

    @Required
    public void setClientBuilder(S3ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public void afterPropertiesSet() throws Exception {
        this.client = this.clientBuilder.getClient();
    }

    public void destroy() {
        this.client.shutdown();
    }

    protected boolean isResultEmpty(ListObjectsV2Result result) {
        return !(result.getCommonPrefixes() != null && !result.getCommonPrefixes().isEmpty() || result.getObjectSummaries() != null && !result.getObjectSummaries().isEmpty());
    }

    public Context createContext(String id, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws RootFolderNotFoundException, StoreException, AuthenticationException {
        AmazonS3URI uri = new AmazonS3URI(StringUtils.removeEnd((String)rootFolderPath, (String)DELIMITER));
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(uri.getBucket()).withPrefix(uri.getKey()).withDelimiter(DELIMITER);
        ListObjectsV2Result result = this.client.listObjectsV2(request);
        if (this.isResultEmpty(result)) {
            throw new RootFolderNotFoundException("Root folder " + rootFolderPath + " not found");
        }
        return new S3Context(id, (ContentStoreAdapter)this, rootFolderPath, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles, uri);
    }

    protected Content getContent(Context context, CachingOptions cachingOptions, File file) throws InvalidContextException, StoreException {
        S3Context s3Context = (S3Context)context;
        String key = ((S3File)file).getKey();
        logger.debug("Getting content for key {}", (Object)key);
        try {
            GetObjectRequest request = new GetObjectRequest(s3Context.getBucket(), key);
            S3Object object = this.client.getObject(request);
            return new S3Content(object);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                throw new StoreException("No item found for key " + key);
            }
            throw new StoreException("Error getting item for key " + key, (Throwable)e);
        }
    }

    @Override
    protected File doFindFile(Context context, String path) throws InvalidContextException, StoreException {
        block9: {
            if (context.ignoreHiddenFiles() && this.isHidden(path)) {
                return null;
            }
            S3Context s3Context = (S3Context)context;
            String key = StringUtils.appendIfMissing((String)s3Context.getKey(), (CharSequence)path, (CharSequence[])new CharSequence[0]);
            logger.debug("Getting file for key {}", (Object)key);
            if (StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)key))) {
                try {
                    ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(s3Context.getBucket()).withPrefix(key).withDelimiter(DELIMITER);
                    ListObjectsV2Result result = this.client.listObjectsV2(request);
                    if (!this.isResultEmpty(result)) {
                        return new S3Prefix(key);
                    }
                    break block9;
                }
                catch (AmazonS3Exception e) {
                    if (e.getStatusCode() == 404) {
                        logger.debug("No object found for key {}", (Object)key);
                        break block9;
                    }
                    throw new StoreException("Error listing objects for key " + key, (Throwable)e);
                }
            }
            try {
                if (this.client.doesObjectExist(s3Context.getBucket(), key)) {
                    return new S3File(key);
                }
                logger.debug("No object found for key {}", (Object)key);
            }
            catch (AmazonS3Exception e) {
                throw new StoreException("Error checking if object for key " + key + " exists", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected List<File> doGetChildren(Context context, File dir) throws InvalidContextException, StoreException {
        ListObjectsV2Result result;
        if (!(dir instanceof S3Prefix)) {
            throw new StoreException("Can't get children for file " + dir);
        }
        S3Context s3Context = (S3Context)context;
        S3Prefix s3Prefix = (S3Prefix)dir;
        logger.debug("Getting children for key {}", (Object)s3Prefix.getPrefix());
        CachingAwareList children = new CachingAwareList();
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(s3Context.getBucket()).withPrefix(s3Prefix.getPrefix()).withDelimiter(DELIMITER);
        do {
            if (this.isResultEmpty(result = this.client.listObjectsV2(request))) {
                return null;
            }
            result.getCommonPrefixes().stream().filter(p -> !context.ignoreHiddenFiles() || !this.isHidden((String)p)).forEach(arg_0 -> S3ContentStoreAdapter.lambda$doGetChildren$1((List)children, arg_0));
            result.getObjectSummaries().stream().filter(s -> !context.ignoreHiddenFiles() || !this.isHidden(s.getKey())).forEach(arg_0 -> S3ContentStoreAdapter.lambda$doGetChildren$3((List)children, arg_0));
            request.setContinuationToken(result.getNextContinuationToken());
        } while (result.isTruncated());
        return children;
    }

    public boolean validate(Context context) throws StoreException, AuthenticationException {
        S3Context s3Context = (S3Context)context;
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(s3Context.getBucket()).withPrefix(s3Context.getKey()).withDelimiter(DELIMITER);
        ListObjectsV2Result result = this.client.listObjectsV2(request);
        return !this.isResultEmpty(result);
    }

    public void destroyContext(Context context) throws StoreException, AuthenticationException {
    }

    private boolean isHidden(String path) {
        return FilenameUtils.getName((String)path).startsWith(".");
    }

    private static /* synthetic */ void lambda$doGetChildren$3(List children, S3ObjectSummary s) {
        children.add(new S3File(s.getKey()));
    }

    private static /* synthetic */ void lambda$doGetChildren$1(List children, String p) {
        children.add(new S3Prefix(p));
    }
}

