/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.store.s3;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.cache.impl.AbstractCachingAwareObject;

public class S3Prefix
extends AbstractCachingAwareObject
implements File {
    protected String prefix;

    public S3Prefix(String prefix) {
        if (!prefix.equals("/")) {
            prefix = StringUtils.stripStart((String)prefix, (String)"/");
            prefix = StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return FilenameUtils.getName((String)StringUtils.removeEnd((String)this.prefix, (String)"/"));
    }

    public String getPath() {
        return this.prefix;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isDirectory() {
        return true;
    }

    public String toString() {
        return "S3Prefix{prefix='" + this.prefix + '\'' + '}';
    }
}

