/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.store.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.service.context.SiteListResolver;
import org.craftercms.engine.store.s3.util.S3ClientBuilder;
import org.springframework.beans.factory.annotation.Required;

public class S3SiteListResolver
implements SiteListResolver {
    protected String siteNameMacroPlaceholder;
    protected AmazonS3URI s3Uri;
    protected S3ClientBuilder clientBuilder;

    public S3SiteListResolver() {
        this.setSiteNameMacroName("siteName");
    }

    public void setSiteNameMacroName(String siteNameMacroName) {
        this.siteNameMacroPlaceholder = "{" + siteNameMacroName + "}";
    }

    @Required
    public void setS3Uri(String s3Uri) {
        this.s3Uri = new AmazonS3URI(s3Uri);
    }

    @Required
    public void setClientBuilder(S3ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public Collection<String> getSiteList() {
        String bucketName = this.s3Uri.getBucket();
        if (bucketName.contains(this.siteNameMacroPlaceholder)) {
            String bucketNameRegex = bucketName.replace(this.siteNameMacroPlaceholder, "(.+)");
            return this.getSiteListFromBucketNames(bucketNameRegex);
        }
        String rootPrefix = StringUtils.substringBefore((String)this.s3Uri.getKey(), (String)this.siteNameMacroPlaceholder);
        return this.getSiteListFromBucketKeys(bucketName, rootPrefix);
    }

    protected Collection<String> getSiteListFromBucketNames(String bucketNameRegex) {
        ArrayList<String> siteNames = new ArrayList<String>();
        AmazonS3 client = this.clientBuilder.getClient();
        List buckets = client.listBuckets();
        if (CollectionUtils.isNotEmpty((Collection)buckets)) {
            for (Bucket bucket : buckets) {
                Matcher bucketNameMatcher = Pattern.compile(bucketNameRegex).matcher(bucket.getName());
                if (!bucketNameMatcher.matches()) continue;
                siteNames.add(bucketNameMatcher.group(1));
            }
        }
        return siteNames;
    }

    protected Collection<String> getSiteListFromBucketKeys(String bucketName, String rootPrefix) {
        ListObjectsV2Request request;
        ArrayList<String> siteNames = new ArrayList<String>();
        AmazonS3 client = this.clientBuilder.getClient();
        ListObjectsV2Result result = client.listObjectsV2(request = new ListObjectsV2Request().withBucketName(bucketName).withPrefix(rootPrefix).withDelimiter("/"));
        if (CollectionUtils.isNotEmpty((Collection)result.getCommonPrefixes())) {
            result.getCommonPrefixes().stream().map(prefix -> StringUtils.stripEnd((String)StringUtils.removeStart((String)prefix, (String)rootPrefix), (String)"/")).forEach(siteNames::add);
        }
        return siteNames;
    }
}

