/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.engine.targeting.CandidateTargetIdsResolver;
import org.craftercms.engine.targeting.CandidateTargetedUrlsResolver;
import org.craftercms.engine.targeting.TargetIdManager;
import org.craftercms.engine.targeting.TargetedUrlComponents;
import org.craftercms.engine.targeting.TargetedUrlStrategy;
import org.craftercms.engine.util.TargetingUtils;
import org.springframework.beans.factory.annotation.Required;

public class CandidateTargetedUrlsResolverImpl
implements CandidateTargetedUrlsResolver {
    protected TargetIdManager targetIdManager;
    protected TargetedUrlStrategy targetedUrlStrategy;
    protected CandidateTargetIdsResolver candidateTargetIdsResolver;

    @Required
    public void setTargetIdManager(TargetIdManager targetIdManager) {
        this.targetIdManager = targetIdManager;
    }

    @Required
    public void setTargetedUrlStrategy(TargetedUrlStrategy targetedUrlStrategy) {
        this.targetedUrlStrategy = targetedUrlStrategy;
    }

    @Required
    public void setCandidateTargetIdsResolver(CandidateTargetIdsResolver candidateTargetIdsResolver) {
        this.candidateTargetIdsResolver = candidateTargetIdsResolver;
    }

    @Override
    public List<String> getUrls(String targetedUrl) {
        ArrayList<String> candidateUrls = new ArrayList<String>();
        String rootFolder = TargetingUtils.getMatchingRootFolder(targetedUrl);
        if (StringUtils.isNotEmpty((CharSequence)rootFolder)) {
            String relativeTargetedUrl = StringUtils.substringAfter((String)targetedUrl, (String)rootFolder);
            TargetedUrlComponents urlComp = this.targetedUrlStrategy.parseTargetedUrl(relativeTargetedUrl);
            if (urlComp != null) {
                String fallbackTargetId;
                String prefix = UrlUtils.concat((String)rootFolder, (String)urlComp.getPrefix());
                String suffix = urlComp.getSuffix();
                String targetId = urlComp.getTargetId();
                List<String> candidateTargetIds = this.candidateTargetIdsResolver.getTargetIds(targetId, fallbackTargetId = this.targetIdManager.getFallbackTargetId());
                if (CollectionUtils.isNotEmpty(candidateTargetIds)) {
                    for (String candidateTargetId : candidateTargetIds) {
                        candidateUrls.add(this.targetedUrlStrategy.buildTargetedUrl(prefix, candidateTargetId, suffix));
                    }
                } else {
                    candidateUrls.add(targetedUrl);
                }
            } else {
                candidateUrls.add(targetedUrl);
            }
        } else {
            candidateUrls.add(targetedUrl);
        }
        return candidateUrls;
    }
}

