/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.LocaleUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

public class ConfigAwareCookieLocaleResolver
extends CookieLocaleResolver {
    public static final String DEFAULT_LOCALE_CONFIG_KEY = "defaultLocale";

    public String getCookieName() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return String.format("%s-%s", super.getCookieName(), siteContext.getSiteName());
        }
        return super.getCookieName();
    }

    protected Locale determineDefaultLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocaleFromConfig();
        if (defaultLocale != null) {
            return defaultLocale;
        }
        return super.determineDefaultLocale(request);
    }

    protected Locale getDefaultLocaleFromConfig() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            Locale defaultLocale = LocaleUtils.toLocale((String)config.getString(DEFAULT_LOCALE_CONFIG_KEY));
            if (defaultLocale != null && !LocaleUtils.isAvailableLocale((Locale)defaultLocale)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(defaultLocale + " is not one of the available locales"));
                }
                return null;
            }
            return defaultLocale;
        }
        return null;
    }
}

