/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.impl.AbstractTargetIdManager;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocaleTargetIdManager
extends AbstractTargetIdManager {
    @Override
    public String getCurrentTargetId() throws IllegalStateException {
        Locale currentLocale = LocaleContextHolder.getLocale();
        if (currentLocale != null) {
            return StringUtils.lowerCase((String)currentLocale.toString());
        }
        return null;
    }

    @Override
    public List<String> getAvailableTargetIds() {
        Object[] availableTargetIds = SiteProperties.getAvailableTargetIds();
        if (ArrayUtils.isEmpty((Object[])availableTargetIds)) {
            List availableLocales = LocaleUtils.availableLocaleList();
            ArrayList<String> availableLocaleStrs = new ArrayList<String>(availableLocales.size());
            for (Locale locale : availableLocales) {
                String localeStr = locale.toString();
                if (!StringUtils.isNotEmpty((CharSequence)localeStr)) continue;
                availableLocaleStrs.add(StringUtils.lowerCase((String)localeStr));
            }
            return availableLocaleStrs;
        }
        return Arrays.asList(availableTargetIds);
    }
}

