/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.targeting.CandidateTargetedUrlsResolver;
import org.craftercms.engine.util.TargetingUtils;
import org.craftercms.engine.util.store.decorators.ContentStoreAdapterDecorator;
import org.craftercms.engine.util.store.decorators.DecoratedStoreAdapterContext;
import org.springframework.beans.factory.annotation.Required;

public class TargetedContentStoreAdapterDecorator
implements ContentStoreAdapterDecorator {
    public static final Log logger = LogFactory.getLog(TargetedContentStoreAdapterDecorator.class);
    protected ContentStoreAdapter actualStoreAdapter;
    protected CandidateTargetedUrlsResolver candidateTargetedUrlsResolver;

    @Override
    public void setActualStoreAdapter(ContentStoreAdapter actualStoreAdapter) {
        this.actualStoreAdapter = actualStoreAdapter;
    }

    @Required
    public void setCandidateTargetedUrlsResolver(CandidateTargetedUrlsResolver candidateTargetedUrlsResolver) {
        this.candidateTargetedUrlsResolver = candidateTargetedUrlsResolver;
    }

    public Context createContext(String id, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws StoreException, AuthenticationException {
        Context context = this.actualStoreAdapter.createContext(id, rootFolderPath, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        return new DecoratedStoreAdapterContext(context, this);
    }

    public boolean validate(Context context) throws StoreException, AuthenticationException {
        return this.actualStoreAdapter.validate(((DecoratedStoreAdapterContext)context).getActualContext());
    }

    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
        context = ((DecoratedStoreAdapterContext)context).getActualContext();
        this.actualStoreAdapter.destroyContext(context);
    }

    public boolean exists(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        context = ((DecoratedStoreAdapterContext)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath(path)) {
            List<String> candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty(candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    if (!this.actualStoreAdapter.exists(context, cachingOptions, candidatePath)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted of " + path + " found at " + candidatePath));
                    }
                    return true;
                }
                return false;
            }
            return this.actualStoreAdapter.exists(context, cachingOptions, path);
        }
        return this.actualStoreAdapter.exists(context, cachingOptions, path);
    }

    public Content findContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        context = ((DecoratedStoreAdapterContext)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath(path)) {
            List<String> candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty(candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    Content content = this.actualStoreAdapter.findContent(context, cachingOptions, candidatePath);
                    if (content == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return content;
                }
                return null;
            }
            return this.actualStoreAdapter.findContent(context, cachingOptions, path);
        }
        return this.actualStoreAdapter.findContent(context, cachingOptions, path);
    }

    public Item findItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, XmlFileParseException, StoreException {
        context = ((DecoratedStoreAdapterContext)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath(path)) {
            List<String> candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty(candidatePaths)) {
                for (String candidatePath : candidatePaths) {
                    Item item = this.actualStoreAdapter.findItem(context, cachingOptions, candidatePath, withDescriptor);
                    if (item == null) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return item;
                }
                return null;
            }
            return this.actualStoreAdapter.findItem(context, cachingOptions, path, withDescriptor);
        }
        return this.actualStoreAdapter.findItem(context, cachingOptions, path, withDescriptor);
    }

    public List<Item> findItems(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, XmlFileParseException, StoreException {
        context = ((DecoratedStoreAdapterContext)context).getActualContext();
        if (SiteProperties.isTargetingEnabled() && !TargetingUtils.excludePath(path)) {
            List<String> candidatePaths = this.candidateTargetedUrlsResolver.getUrls(path);
            if (CollectionUtils.isNotEmpty(candidatePaths)) {
                if (SiteProperties.isMergeFolders()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Merging child items of " + candidatePaths));
                    }
                    List<Item> mergedItems = null;
                    for (String candidatePath : candidatePaths) {
                        List items = this.actualStoreAdapter.findItems(context, cachingOptions, candidatePath);
                        mergedItems = this.mergeItems(mergedItems, items);
                    }
                    return mergedItems;
                }
                for (String candidatePath : candidatePaths) {
                    List items = this.actualStoreAdapter.findItems(context, cachingOptions, candidatePath);
                    if (!CollectionUtils.isNotEmpty((Collection)items)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Targeted version of " + path + " found at " + candidatePath));
                    }
                    return items;
                }
                return null;
            }
            return this.actualStoreAdapter.findItems(context, cachingOptions, path);
        }
        return this.actualStoreAdapter.findItems(context, cachingOptions, path);
    }

    protected List<Item> mergeItems(List<Item> overriding, List<Item> original) {
        if (overriding == null) {
            return original;
        }
        if (original == null) {
            return overriding;
        }
        CachingAwareList merged = new CachingAwareList(new ArrayList<Item>(overriding));
        for (Item item : original) {
            if (this.containsItem((List<Item>)merged, item)) continue;
            merged.add(item);
        }
        return merged;
    }

    protected boolean containsItem(List<Item> list, Item item) {
        int idx = ListUtils.indexOf(list, it -> it.getName().equals(item.getName()));
        return idx >= 0;
    }
}

