/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.engine.targeting.impl.AbstractTargetedUrlStrategy;

public class TargetedUrlByFolderStrategy
extends AbstractTargetedUrlStrategy {
    public static final String TARGETED_URL_REGEX_FORMAT = "^/?(%s)(/.+)?$";
    public static final int TARGET_ID_GROUP = 1;
    public static final int SUFFIX_GROUP = 2;

    @Override
    public boolean isFileNameBasedStrategy() {
        return false;
    }

    @Override
    public String buildTargetedUrl(String prefix, String targetId, String suffix) {
        String targetedUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            targetedUrl = UrlUtils.concat((String)targetedUrl, (String)prefix);
        }
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            targetedUrl = UrlUtils.concat((String)targetedUrl, (String)targetId);
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            targetedUrl = UrlUtils.concat((String)targetedUrl, (String)suffix);
        }
        targetedUrl = StringUtils.prependIfMissing((String)targetedUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return targetedUrl;
    }

    @Override
    protected String getPrefix(Matcher matcher) {
        return null;
    }

    @Override
    protected String getTargetId(Matcher matcher) {
        return matcher.group(1);
    }

    @Override
    protected String getSuffix(Matcher matcher) {
        return matcher.group(2);
    }

    @Override
    protected Pattern getTargetedUrlPattern() {
        String availableTargetIds = StringUtils.join(this.targetIdManager.getAvailableTargetIds(), (char)'|');
        String targetedUrlByFilePattern = String.format(TARGETED_URL_REGEX_FORMAT, availableTargetIds);
        return Pattern.compile(targetedUrlByFilePattern);
    }

    @Override
    protected String doToTargetedUrl(String url, String currentTargetId) {
        if (StringUtils.isNotEmpty((CharSequence)currentTargetId)) {
            return this.buildTargetedUrl("", currentTargetId, url);
        }
        return url;
    }
}

