/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.url.rewrite;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.engine.service.context.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class UrlRewriteFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(UrlRewriteFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    @PostConstruct
    public void init() {
        Log.setLevel((String)"slf4j");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        UrlRewriter urlRewriter = this.getUrlRewriter();
        boolean requestRewritten = false;
        if (urlRewriter != null) {
            httpServletResponse = new UrlRewriteWrappedResponse(httpServletResponse, httpServletRequest, urlRewriter);
            requestRewritten = urlRewriter.processRequest(httpServletRequest, httpServletResponse, chain);
        } else if (logger.isDebugEnabled()) {
            logger.debug("URL rewriter engine not loaded, ignoring request");
        }
        if (!requestRewritten) {
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    protected UrlRewriter getUrlRewriter() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getUrlRewriter();
        }
        throw new IllegalStateException("No site context found to get the URL rewriter from");
    }

    public void destroy() {
    }
}

