/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util;

import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import org.craftercms.engine.scripting.impl.ScriptJob;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.quartz.JobContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class SchedulingUtils {
    private SchedulingUtils() {
    }

    public static Trigger createCronTrigger(String triggerName, String cronExpression) {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        return trigger;
    }

    public static JobDetail createScriptJob(SiteContext siteContext, String jobName, String scriptUrl, ServletContext servletContext) {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("siteContext", (Object)siteContext);
        dataMap.put("scriptUrl", scriptUrl);
        dataMap.put("servletContext", (Object)servletContext);
        JobDetail job = JobBuilder.newJob(ScriptJob.class).withIdentity(jobName).setJobData(dataMap).build();
        return job;
    }

    public static JobContext createJobContext(SiteContext siteContext, String scriptUrl, String cronExpression, ServletContext servletContext) {
        String jobName = siteContext.getSiteName() + ":" + scriptUrl;
        JobDetail detail = SchedulingUtils.createScriptJob(siteContext, jobName, scriptUrl, servletContext);
        Trigger trigger = SchedulingUtils.createCronTrigger("trigger for " + jobName, cronExpression);
        String description = "Job{url='" + scriptUrl + "', cron='" + cronExpression + "'}";
        return new JobContext(detail, trigger, description);
    }

    public static Scheduler createScheduler(String schedulerName, Executor threaPoolExecutor) throws SchedulerException {
        try {
            SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
            schedulerFactoryBean.setSchedulerName(schedulerName);
            schedulerFactoryBean.setTaskExecutor(threaPoolExecutor);
            schedulerFactoryBean.afterPropertiesSet();
            return schedulerFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to create scheduler", (Throwable)e);
        }
    }
}

