/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.breadcrumb;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.service.Context;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.properties.SiteProperties;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.breadcrumb.BreadcrumbItem;
import org.springframework.beans.factory.annotation.Required;

@Deprecated
public class BreadcrumbBuilder {
    public static final String BREADCRUMB_CONST_KEY_ELEM = "breadcrumb";
    public static final String HOME_BREADCRUMB_NAME = "Home";
    protected CacheTemplate cacheTemplate;
    protected SiteItemService siteItemService;
    protected String homePath;
    protected String breadcrumbNameXPathQuery;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    @Required
    public void setBreadcrumbNameXPathQuery(String breadcrumbNameXPathQuery) {
        this.breadcrumbNameXPathQuery = breadcrumbNameXPathQuery;
    }

    public List<BreadcrumbItem> buildBreadcrumb(String url) {
        Context context = SiteContext.getCurrent().getContext();
        return (List)this.cacheTemplate.getObject(context, () -> {
            String indexFileName = SiteProperties.getIndexFileName();
            CachingAwareList breadcrumb = new CachingAwareList();
            String breadcrumbUrl = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)url, (String)this.homePath), (String)indexFileName);
            String[] breadcrumbUrlComponents = breadcrumbUrl.split("/");
            String currentUrl = this.homePath;
            for (String breadcrumbUrlComponent : breadcrumbUrlComponents) {
                SiteItem siteItem;
                if (StringUtils.isNotEmpty((CharSequence)breadcrumbUrlComponent)) {
                    currentUrl = currentUrl + "/" + breadcrumbUrlComponent;
                }
                if ((siteItem = this.siteItemService.getSiteItem(UrlUtils.concat((String)currentUrl, (String)indexFileName))) == null || siteItem.getDom() == null) continue;
                String breadcrumbName = siteItem.queryValue(this.breadcrumbNameXPathQuery);
                if (StringUtils.isEmpty((CharSequence)breadcrumbName)) {
                    breadcrumbName = StringUtils.isNotEmpty((CharSequence)breadcrumbUrlComponent) ? StringUtils.capitalize((String)breadcrumbUrlComponent.replace("-", " ").replace(".xml", "")) : HOME_BREADCRUMB_NAME;
                }
                breadcrumb.add((Object)new BreadcrumbItem(currentUrl, breadcrumbName));
            }
            return breadcrumb;
        }, new Object[]{url, BREADCRUMB_CONST_KEY_ELEM});
    }
}

