/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.config;

import org.craftercms.commons.config.PublishingTargetResolver;
import org.craftercms.engine.service.context.SiteContext;

public class SiteAwarePublishingTargetResolver
implements PublishingTargetResolver {
    protected boolean preview;
    protected String stagingPattern;

    public SiteAwarePublishingTargetResolver(boolean preview, String stagingPattern) {
        this.preview = preview;
        this.stagingPattern = stagingPattern;
    }

    public String getPublishingTarget() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext == null) {
            throw new IllegalStateException("Can't resolve the current site target");
        }
        return this.getPublishingTarget(siteContext.getSiteName());
    }

    public String getPublishingTarget(String siteName) {
        if (this.preview) {
            return "preview";
        }
        if (siteName.matches(this.stagingPattern)) {
            return "staging";
        }
        return "live";
    }
}

