/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.config.profiles;

import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationMapper;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.commons.config.profiles.ConfigurationProfile;
import org.craftercms.commons.config.profiles.ConfigurationProfileLoader;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;

public class ConfigurationProfileLoaderImpl<T extends ConfigurationProfile>
implements ConfigurationProfileLoader<T> {
    private String profilesModule;
    private String profilesUrl;
    private ConfigurationMapper<T> profileMapper;
    private ConfigurationProvider configurationProvider;

    @Required
    public void setProfilesModule(String profilesModule) {
        this.profilesModule = profilesModule;
    }

    @Required
    public void setProfilesUrl(String profilesUrl) {
        this.profilesUrl = profilesUrl;
    }

    @Required
    public void setProfileMapper(ConfigurationMapper<T> profileMapper) {
        this.profileMapper = profileMapper;
    }

    @Required
    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public T loadProfile(String id) throws ConfigurationException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            try {
                return (T)((ConfigurationProfile)this.profileMapper.readConfig(this.configurationProvider, this.profilesModule, this.profilesUrl, null, id));
            }
            catch (Exception e) {
                throw new ConfigurationException("Error while loading profile " + id + " from configuration at " + this.profilesUrl, (Throwable)e);
            }
        }
        throw new IllegalStateException("No current site context found");
    }
}

