/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.deployment;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.engine.event.CacheClearStartedEvent;
import org.craftercms.engine.event.GraphQLBuildStartedEvent;
import org.craftercms.engine.event.SiteContextCreatedEvent;
import org.craftercms.engine.event.SiteContextInitializedEvent;
import org.craftercms.engine.event.SiteEvent;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DeploymentEventsWatcher
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEventsWatcher.class);
    public static final String DEFAULT_DEPLOYMENT_EVENTS_FILE_URL = "deployment-events.properties";
    private static final String LATEST_EVENT_KEY_FORMAT = "siteName=%s, eventType=%s";
    private static final String CLEAR_CACHE_EVENT_KEY = "events.deployment.clearCache";
    private static final String REBUILD_CONTEXT_EVENT_KEY = "events.deployment.rebuildContext";
    private static final String REBUILD_GRAPHQL_EVENT_KEY = "events.deployment.rebuildGraphQL";
    private String deploymentEventsFileUrl = "deployment-events.properties";
    private SiteContextManager siteContextManager;
    private volatile boolean startupCompleted = false;
    private Map<String, SiteEvent> latestEvents = new ConcurrentHashMap<String, SiteEvent>();

    public void setDeploymentEventsFileUrl(String deploymentEventsFileUrl) {
        this.deploymentEventsFileUrl = deploymentEventsFileUrl;
    }

    @Required
    public void setSiteContextManager(SiteContextManager siteContextManager) {
        this.siteContextManager = siteContextManager;
    }

    public void checkForEvents() {
        if (this.startupCompleted) {
            logger.debug("Deployment events watcher running...");
            this.siteContextManager.syncContexts();
            for (SiteContext siteContext : this.siteContextManager.listContexts()) {
                this.checkForSiteEvents(siteContext);
            }
        }
    }

    public void checkForSiteEvents(SiteContext siteContext) {
        long rebuildContextEvent;
        Properties deploymentEvents;
        String siteName = siteContext.getSiteName();
        try {
            deploymentEvents = this.loadDeploymentEvents(siteContext);
        }
        catch (IOException e) {
            logger.error("Unable to load deployment events for site '{}'", (Object)siteName, (Object)e);
            return;
        }
        boolean rebuildContextTriggered = false;
        logger.debug("Checking deployment events for site {}...", (Object)siteName);
        long lastContextBuildEvent = this.getLatestEventTimestamp(siteName, SiteContextCreatedEvent.class);
        if (deploymentEvents.containsKey(REBUILD_CONTEXT_EVENT_KEY) && lastContextBuildEvent < (rebuildContextEvent = this.getEventProperty(deploymentEvents, REBUILD_CONTEXT_EVENT_KEY))) {
            logger.info("Rebuild context deployment event received. Rebuilding context for site {}...", (Object)siteName);
            this.siteContextManager.startContextRebuild(siteContext.getSiteName(), siteContext.isFallback());
            rebuildContextTriggered = true;
        }
        if (!rebuildContextTriggered && deploymentEvents.containsKey(CLEAR_CACHE_EVENT_KEY)) {
            long clearCacheEvent = this.getEventProperty(deploymentEvents, CLEAR_CACHE_EVENT_KEY);
            long lastCacheClearEvent = this.getLatestEventTimestamp(siteName, CacheClearStartedEvent.class);
            if (lastContextBuildEvent < clearCacheEvent && lastCacheClearEvent < clearCacheEvent) {
                logger.info("Clear cache deployment event received. Clearing cache for site {}...", (Object)siteName);
                siteContext.startCacheClear();
            }
        }
        if (!rebuildContextTriggered && deploymentEvents.containsKey(REBUILD_GRAPHQL_EVENT_KEY)) {
            long rebuildGraphQLEvent = this.getEventProperty(deploymentEvents, REBUILD_GRAPHQL_EVENT_KEY);
            long lastRebuildGraphQLEvent = this.getLatestEventTimestamp(siteName, GraphQLBuildStartedEvent.class);
            if (lastContextBuildEvent < rebuildGraphQLEvent && lastRebuildGraphQLEvent < rebuildGraphQLEvent) {
                logger.info("Rebuild GraphQL deployment event received. Rebuilding schema for site {}...", (Object)siteName);
                siteContext.startGraphQLSchemaBuild();
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SiteContextInitializedEvent) {
            this.startupCompleted = true;
        } else if (event instanceof SiteEvent) {
            SiteEvent siteEvent = (SiteEvent)event;
            String siteName = siteEvent.getSiteContext().getSiteName();
            Class<?> eventClass = ((Object)((Object)siteEvent)).getClass();
            if (eventClass.equals(SiteContextCreatedEvent.class) || eventClass.equals(CacheClearStartedEvent.class) || eventClass.equals(GraphQLBuildStartedEvent.class)) {
                this.latestEvents.put(String.format(LATEST_EVENT_KEY_FORMAT, siteName, eventClass), siteEvent);
            }
        }
    }

    private long getLatestEventTimestamp(String siteName, Class<? extends SiteEvent> eventClass) {
        SiteEvent event = this.latestEvents.get(String.format(LATEST_EVENT_KEY_FORMAT, siteName, eventClass));
        if (event != null) {
            return event.getTimestamp();
        }
        return -1L;
    }

    private Properties loadDeploymentEvents(SiteContext siteContext) throws IOException {
        ContentStoreService contentStoreService = siteContext.getStoreService();
        Context context = siteContext.getContext();
        CachingOptions cachingOptions = CachingOptions.CACHE_OFF_CACHING_OPTIONS;
        Content content = contentStoreService.findContent(context, cachingOptions, this.deploymentEventsFileUrl);
        Properties events = new Properties();
        if (content != null) {
            events.load(new InputStreamReader(content.getInputStream(), StandardCharsets.UTF_8));
        }
        return events;
    }

    private long getEventProperty(Properties deploymentEvents, String name) {
        return Instant.parse(deploymentEvents.getProperty(name)).toEpochMilli();
    }
}

