/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.Version;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import org.craftercms.engine.service.context.SiteContext;

public class CrafterCacheAwareConfiguration
extends Configuration {
    protected boolean cacheTemplates;

    public CrafterCacheAwareConfiguration(Version incompatibleImprovements, boolean cacheTemplates) {
        super(incompatibleImprovements);
        this.cacheTemplates = cacheTemplates;
    }

    public Template getTemplate(String name, Locale locale, Object customLookupCondition, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws IOException {
        if (this.cacheTemplates) {
            try {
                return (Template)SiteContext.getFromCurrentCache(() -> {
                    try {
                        return super.getTemplate(name, locale, customLookupCondition, encoding, parseAsFTL, ignoreMissing);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }, name, locale, customLookupCondition, encoding, parseAsFTL);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
        return super.getTemplate(name, locale, customLookupCondition, encoding, parseAsFTL, ignoreMissing);
    }
}

