/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.groovy;

import groovy.lang.GroovyResourceLoader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.url.ContentStoreUrlStreamHandler;

public class ContentStoreGroovyResourceLoader
implements GroovyResourceLoader {
    protected SiteContext siteContext;
    protected ContentStoreUrlStreamHandler urlStreamHandler;
    protected String groovyResourcesUrlPrefix;

    public ContentStoreGroovyResourceLoader(SiteContext siteContext, String groovyResourcesUrlPrefix) {
        this.siteContext = siteContext;
        this.urlStreamHandler = new ContentStoreUrlStreamHandler(siteContext);
        this.groovyResourcesUrlPrefix = groovyResourcesUrlPrefix;
    }

    public URL loadGroovySource(String filename) throws MalformedURLException {
        if (filename.contains(".")) {
            filename = filename.replace('.', '/');
        }
        if (!filename.endsWith("groovy")) {
            filename = filename + ".groovy";
        }
        if (StringUtils.isNotEmpty((CharSequence)this.groovyResourcesUrlPrefix)) {
            filename = UrlUtils.concat((String)this.groovyResourcesUrlPrefix, (String)filename);
        }
        if (this.siteContext.getStoreService().exists(this.siteContext.getContext(), filename)) {
            return this.urlStreamHandler.createUrl(filename);
        }
        return null;
    }
}

