/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.logging;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.craftercms.engine.service.context.SiteContext;

@Plugin(name="CircularQueueLogAppender", category="Core", elementType="appender")
public class CircularQueueLogAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "CircularQueueLogAppender";
    private static Buffer buffer;
    private DateTimeFormatter dateFormat;
    private boolean global;

    protected CircularQueueLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        String siteName = "";
        SiteContext ctx = SiteContext.getCurrent();
        if (ctx != null) {
            siteName = ctx.getSiteName();
        }
        if (this.global || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{siteName})) {
            HashMap<String, Object> mappy = new HashMap<String, Object>();
            mappy.put("site", siteName);
            mappy.put("level", event.getLevel().toString());
            mappy.put("message", event.getMessage().getFormattedMessage());
            mappy.put("thread", event.getThreadName());
            mappy.put("exception", this.subAppend(event));
            mappy.put("timestamp", this.dateFormat.format(Instant.ofEpochMilli(event.getTimeMillis())));
            mappy.put("timestampm", event.getInstant().getEpochMillisecond());
            buffer.add(mappy);
        }
    }

    public void stop() {
        super.stop();
        buffer.clear();
    }

    public static List<Map<String, Object>> getLoggedEvents(String siteId, long since) {
        Iterator iter = buffer.iterator();
        ArrayList<Map<String, Object>> str = new ArrayList<Map<String, Object>>();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            if (!map.get("site").toString().equalsIgnoreCase(siteId) || !Instant.ofEpochMilli((Long)map.get("timestampm")).isAfter(Instant.ofEpochMilli(since))) continue;
            str.add(map);
        }
        return str;
    }

    protected String subAppend(LogEvent event) {
        StringBuilder sb = new StringBuilder();
        if (!this.ignoreExceptions() && !Objects.isNull(event.getThrown())) {
            sb.append(System.lineSeparator());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            event.getThrown().printStackTrace(pw);
            BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
            br.lines().forEach(line -> sb.append((String)line).append(System.lineSeparator()));
        }
        return sb.toString();
    }

    @PluginFactory
    public static CircularQueueLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="maxQueueSize") int maxQueueSize, @PluginAttribute(value="dateFormat") String dateFormat, @PluginAttribute(value="global") boolean global) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            LOGGER.error("No name provided for CircularQueueLogAppender");
            return null;
        }
        if (Objects.isNull(layout)) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (Objects.isNull(buffer)) {
            LOGGER.debug("Initializing circular log queue buffer");
            if (maxQueueSize <= 0) {
                throw new IllegalArgumentException("maxQueueSize must be a integer bigger that 0");
            }
            buffer = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(maxQueueSize));
        }
        CircularQueueLogAppender appender = new CircularQueueLogAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, null);
        appender.dateFormat = DateTimeFormatter.ofPattern(dateFormat).withZone(ZoneId.of("UTC"));
        appender.global = global;
        return appender;
    }
}

