/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="ThreadContextKeyExistsFilter", category="Core", elementType="filter")
public class ThreadContextKeyExistsFilter
extends AbstractFilter {
    public static final String PLUGIN_NAME = "ThreadContextKeyExistsFilter";
    private String key;
    private boolean acceptIfKeyExists;
    private boolean denyIfKeyDoesNotExist;

    public void setKey(String key) {
        this.key = key;
    }

    public void setAcceptIfKeyExists(boolean acceptIfKeyExists) {
        this.acceptIfKeyExists = acceptIfKeyExists;
    }

    public void setDenyIfKeyDoesNotExist(boolean denyIfKeyDoesNotExist) {
        this.denyIfKeyDoesNotExist = denyIfKeyDoesNotExist;
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter();
    }

    public Filter.Result filter() {
        if (this.key == null) {
            return Filter.Result.NEUTRAL;
        }
        if (ThreadContext.get((String)this.key) != null) {
            if (this.acceptIfKeyExists) {
                return Filter.Result.ACCEPT;
            }
            return Filter.Result.DENY;
        }
        if (this.denyIfKeyDoesNotExist) {
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    @PluginFactory
    public static ThreadContextKeyExistsFilter createFilter(@PluginAttribute(value="key") String key, @PluginAttribute(value="acceptIfKeyExists") boolean acceptIfKeyExists, @PluginAttribute(value="denyIfKeyDoesNotExist") boolean denyIfKeyDoesNotExist) {
        ThreadContextKeyExistsFilter filter = new ThreadContextKeyExistsFilter();
        filter.setKey(key);
        filter.setAcceptIfKeyExists(acceptIfKeyExists);
        filter.setDenyIfKeyDoesNotExist(denyIfKeyDoesNotExist);
        return filter;
    }
}

