/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.predicates;

import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.service.Item;
import org.springframework.beans.factory.annotation.Required;

public class DisabledItemPredicate
implements Predicate<Item> {
    private static final Log logger = LogFactory.getLog(DisabledItemPredicate.class);
    protected String disabledXPathQuery;

    @Required
    public void setDisabledXPathQuery(String disabledXPathQuery) {
        this.disabledXPathQuery = disabledXPathQuery;
    }

    public boolean evaluate(Item item) {
        String disabled = item.queryDescriptorValue(this.disabledXPathQuery);
        if (StringUtils.isNotEmpty((CharSequence)disabled) && Boolean.parseBoolean(disabled)) {
            logger.info((Object)("Item " + item.getDescriptorUrl() + " is disabled"));
            return false;
        }
        return true;
    }
}

