/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.predicates;

import java.util.Date;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.converters.Converter;
import org.craftercms.core.service.Item;
import org.springframework.beans.factory.annotation.Required;

public class ExpiredItemPredicate
implements Predicate<Item> {
    private static final Log logger = LogFactory.getLog(ExpiredItemPredicate.class);
    protected String expiredXPathQuery;
    protected Converter<String, Date> dateConverter;

    @Required
    public void setExpiredXPathQuery(String expiredXPathQuery) {
        this.expiredXPathQuery = expiredXPathQuery;
    }

    @Required
    public void setDateConverter(Converter<String, Date> dateConverter) {
        this.dateConverter = dateConverter;
    }

    public boolean evaluate(Item item) {
        String expired = item.queryDescriptorValue(this.expiredXPathQuery);
        if (StringUtils.isNotEmpty((CharSequence)expired)) {
            Date now = new Date();
            Date expiredDate = (Date)this.dateConverter.convert((Object)expired);
            if (now.before(expiredDate)) {
                return true;
            }
            logger.info((Object)("Item " + item.getDescriptorUrl() + " has expired"));
            return false;
        }
        return true;
    }
}

