/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.core.service.Content;
import org.craftercms.core.store.impl.filesystem.FileSystemFile;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.url.ContentStoreUrlStreamHandler;
import org.springframework.core.io.AbstractResource;

public class ContentStoreResource
extends AbstractResource {
    protected SiteContext siteContext;
    protected String url;

    public ContentStoreResource(SiteContext siteContext, String url) {
        this.siteContext = siteContext;
        this.url = url;
    }

    public boolean exists() {
        return this.siteContext.getStoreService().exists(this.siteContext.getContext(), this.url);
    }

    public URL getURL() throws IOException {
        ContentStoreUrlStreamHandler urlStreamHandler = new ContentStoreUrlStreamHandler(this.siteContext);
        return urlStreamHandler.createUrl(this.url);
    }

    public long contentLength() throws IOException {
        Content content = this.getContent();
        if (content != null) {
            return content.getLength();
        }
        return 0L;
    }

    public long lastModified() throws IOException {
        Content content = this.getContent();
        if (content != null) {
            return content.getLength();
        }
        throw new FileNotFoundException(this.getDescription() + " not found");
    }

    public File getFile() throws IOException {
        Content content = this.getContent();
        if (content != null) {
            if (content instanceof FileSystemFile) {
                return ((FileSystemFile)content).getFile();
            }
            throw new FileNotFoundException(this.getDescription() + " doesn't correspond to a file in the filesystem");
        }
        throw new FileNotFoundException(this.getDescription() + " not found");
    }

    public String getFilename() {
        return FilenameUtils.getName((String)this.url);
    }

    public String getDescription() {
        return this.siteContext.getSiteName() + ":" + this.url;
    }

    public InputStream getInputStream() throws IOException {
        Content content = this.getContent();
        if (content != null) {
            return content.getInputStream();
        }
        throw new FileNotFoundException(this.getDescription() + " not found");
    }

    protected Content getContent() {
        return this.siteContext.getStoreService().findContent(this.siteContext.getContext(), this.url);
    }
}

