/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.context;

import org.craftercms.commons.lang.RegexUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class RestrictedApplicationContext
extends GenericApplicationContext {
    protected String[] defaultPublicBeans;

    public RestrictedApplicationContext(ApplicationContext parent, String[] defaultPublicBeans) {
        super(parent);
        this.defaultPublicBeans = defaultPublicBeans;
    }

    protected boolean isAllowed(String name) {
        return this.containsBeanDefinition(name) || RegexUtils.matchesAny((String)name, (String[])this.defaultPublicBeans);
    }

    public Object getBean(String name) throws BeansException {
        if (this.isAllowed(name)) {
            return super.getBean(name);
        }
        return null;
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        if (this.isAllowed(name)) {
            return (T)super.getBean(name, requiredType);
        }
        return null;
    }
}

