/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.cors;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;

public class SiteAwareCorsConfigurationSource
implements CorsConfigurationSource {
    public static final String CACHE_KEY = "-cors-config";
    public static final String CONFIG_KEY = "cors";
    public static final String ENABLE_KEY = "enable";
    public static final String MAX_AGE_KEY = "accessControlMaxAge";
    public static final String ALLOW_ORIGIN_KEY = "accessControlAllowOrigin";
    public static final String ALLOW_METHODS_KEY = "accessControlAllowMethods";
    public static final String ALLOW_HEADERS_KEY = "accessControlAllowHeaders";
    public static final String ALLOW_CREDENTIALS_KEY = "accessControlAllowCredentials";
    public static final long MAX_AGE_DEFAULT = 86400L;
    public static final String ALLOW_ORIGIN_DEFAULT = "*";
    public static final String ALLOW_METHODS_DEFAULT = "GET, POST, OPTIONS";
    public static final String ALLOW_HEADERS_DEFAULT = "Content-Type";
    public static final boolean ALLOW_CREDENTIALS_DEFAULT = true;
    protected CacheTemplate cacheTemplate;

    public SiteAwareCorsConfigurationSource(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        SiteContext siteContext = SiteContext.getCurrent();
        return (CorsConfiguration)this.cacheTemplate.getObject(siteContext.getContext(), () -> {
            try {
                HierarchicalConfiguration config = siteContext.getConfig();
                HierarchicalConfiguration corsConfig = config.configurationAt(CONFIG_KEY);
                if (corsConfig != null) {
                    return this.getConfiguration(corsConfig);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }, new Object[]{CACHE_KEY});
    }

    protected CorsConfiguration getConfiguration(HierarchicalConfiguration<?> corsConfig) {
        if (corsConfig.getBoolean(ENABLE_KEY, false)) {
            CorsConfiguration config = new CorsConfiguration();
            config.setAllowedOrigins(this.getValues(corsConfig, ALLOW_ORIGIN_KEY, ALLOW_ORIGIN_DEFAULT));
            config.setAllowedMethods(this.getValues(corsConfig, ALLOW_METHODS_KEY, ALLOW_METHODS_DEFAULT));
            config.setAllowedHeaders(this.getValues(corsConfig, ALLOW_HEADERS_KEY, ALLOW_HEADERS_DEFAULT));
            config.setMaxAge(Long.valueOf(corsConfig.getLong(MAX_AGE_KEY, 86400L)));
            config.setAllowCredentials(Boolean.valueOf(corsConfig.getBoolean(ALLOW_CREDENTIALS_KEY, true)));
            return config;
        }
        return null;
    }

    protected List<String> getValues(HierarchicalConfiguration<?> config, String key, String defaultValue) {
        return Arrays.stream(config.getString(key, defaultValue).split(",")).map(String::trim).collect(Collectors.toList());
    }
}

