/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.spring.resources.RangeAwareResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StreamUtils;

public class RangeAwareResourceRegionHttpMessageConverter
extends ResourceRegionHttpMessageConverter {
    protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object instanceof ResourceRegion) {
            this.writeResourceRegion((ResourceRegion)object, outputMessage);
        } else {
            Collection regions = (Collection)object;
            if (regions.size() == 1) {
                this.writeResourceRegion((ResourceRegion)regions.iterator().next(), outputMessage);
            } else {
                this.writeResourceRegionCollection((Collection)object, outputMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResourceRegion(ResourceRegion region, HttpOutputMessage outputMessage) throws IOException {
        InputStream in;
        block3: {
            Assert.notNull((Object)region, (String)"ResourceRegion must not be null");
            HttpHeaders responseHeaders = outputMessage.getHeaders();
            long start = region.getPosition();
            long end = start + region.getCount() - 1L;
            Long resourceLength = region.getResource().contentLength();
            end = Math.min(end, resourceLength - 1L);
            long rangeLength = end - start + 1L;
            responseHeaders.add("Content-Range", "bytes " + start + '-' + end + '/' + resourceLength);
            responseHeaders.setContentLength(rangeLength);
            in = null;
            try {
                Resource resource = region.getResource();
                if (resource instanceof RangeAwareResource) {
                    in = ((RangeAwareResource)resource).getInputStream(start, end);
                    StreamUtils.copy((InputStream)in, (OutputStream)outputMessage.getBody());
                    break block3;
                }
                in = resource.getInputStream();
                StreamUtils.copyRange((InputStream)in, (OutputStream)outputMessage.getBody(), (long)start, (long)end);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResourceRegionCollection(Collection<ResourceRegion> resourceRegions, HttpOutputMessage outputMessage) throws IOException {
        Assert.notNull(resourceRegions, (String)"Collection of ResourceRegion should not be null");
        HttpHeaders responseHeaders = outputMessage.getHeaders();
        MediaType contentType = responseHeaders.getContentType();
        String boundaryString = MimeTypeUtils.generateMultipartBoundaryString();
        responseHeaders.set("Content-Type", "multipart/byteranges; boundary=" + boundaryString);
        OutputStream out = outputMessage.getBody();
        for (ResourceRegion region : resourceRegions) {
            InputStream in;
            block5: {
                long start = region.getPosition();
                long end = start + region.getCount() - 1L;
                in = null;
                try {
                    this.println(out);
                    this.print(out, "--" + boundaryString);
                    this.println(out);
                    if (contentType != null) {
                        this.print(out, "Content-Type: " + contentType.toString());
                        this.println(out);
                    }
                    Long resourceLength = region.getResource().contentLength();
                    end = Math.min(end, resourceLength - 1L);
                    this.print(out, "Content-Range: bytes " + start + '-' + end + '/' + resourceLength);
                    this.println(out);
                    this.println(out);
                    Resource resource = region.getResource();
                    if (resource instanceof RangeAwareResource) {
                        in = ((RangeAwareResource)resource).getInputStream(start, end);
                        StreamUtils.copy((InputStream)in, (OutputStream)out);
                        break block5;
                    }
                    in = resource.getInputStream();
                    StreamUtils.copyRange((InputStream)in, (OutputStream)out, (long)start, (long)end);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        this.println(out);
        this.print(out, "--" + boundaryString + "--");
    }

    protected void println(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    protected void print(OutputStream os, String buf) throws IOException {
        os.write(buf.getBytes(StandardCharsets.US_ASCII));
    }
}

