/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class ConfigAwareAccessDeniedHandler
implements AccessDeniedHandler {
    public static final String ACCESS_DENIED_ERROR_PAGE_URL_KEY = "security.accessDenied.errorPageUrl";

    public String getErrorPage() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey(ACCESS_DENIED_ERROR_PAGE_URL_KEY)) {
            return siteConfig.getString(ACCESS_DENIED_ERROR_PAGE_URL_KEY);
        }
        return null;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            String errorPage = this.getErrorPage();
            if (StringUtils.isNotEmpty((CharSequence)errorPage)) {
                request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
                response.setStatus(403);
                RequestDispatcher dispatcher = request.getRequestDispatcher(errorPage);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(403, accessDeniedException.getMessage());
            }
        }
    }
}

