/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class ConfigAwareAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAwareAuthenticationEntryPoint.class);
    protected Map<String, AuthenticationEntryPoint> entryPoints;
    protected AuthenticationEntryPoint defaultEntryPoint;

    public ConfigAwareAuthenticationEntryPoint(Map<String, AuthenticationEntryPoint> entryPoints, AuthenticationEntryPoint defaultEntryPoint) {
        this.entryPoints = entryPoints;
        this.defaultEntryPoint = defaultEntryPoint;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        logger.debug("Looking for an appropriate authentication entry point");
        AuthenticationEntryPoint actualEntryPoint = this.defaultEntryPoint;
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && MapUtils.isNotEmpty(this.entryPoints)) {
            for (Map.Entry<String, AuthenticationEntryPoint> entry : this.entryPoints.entrySet()) {
                logger.debug("Checking if entry point {} is enabled", (Object)entry.getValue());
                if (!siteConfig.getBoolean(entry.getKey(), false)) continue;
                logger.debug("Using authentication entry point {}", (Object)entry.getValue());
                actualEntryPoint = entry.getValue();
            }
        }
        actualEntryPoint.commence(request, response, e);
    }
}

