/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class ConfigAwareAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    public static final String LOGIN_FAILURE_URL_KEY = "security.login.failureUrl";
    protected String defaultFailureUrl;

    protected String determineFailureUrl() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey(LOGIN_FAILURE_URL_KEY)) {
            return siteConfig.getString(LOGIN_FAILURE_URL_KEY);
        }
        return this.defaultFailureUrl;
    }

    public void setDefaultFailureUrl(String defaultFailureUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)defaultFailureUrl), (String)("'" + defaultFailureUrl + "' is not a valid redirect URL"));
        this.defaultFailureUrl = defaultFailureUrl;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String failureUrl = this.determineFailureUrl();
        if (failureUrl == null) {
            this.logger.debug((Object)"No failure URL set, sending 401 Unauthorized error");
            response.sendError(401, "Authentication Failed: " + exception.getMessage());
        } else {
            this.saveException(request, exception);
            if (this.isUseForward()) {
                this.logger.debug((Object)("Forwarding to " + failureUrl));
                request.getRequestDispatcher(failureUrl).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                this.logger.debug((Object)("Redirecting to " + failureUrl));
                this.getRedirectStrategy().sendRedirect(request, response, failureUrl);
            }
        }
    }
}

