/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class ConfigAwareAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    public static final String LOGIN_DEFAULT_SUCCESS_URL_KEY = "security.login.defaultSuccessUrl";
    public static final String LOGIN_ALWAYS_USE_DEFAULT_SUCCESS_URL_KEY = "security.login.alwaysUseDefaultSuccessUrl";

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getString(LOGIN_DEFAULT_SUCCESS_URL_KEY, super.determineTargetUrl(request, response));
        }
        return super.determineTargetUrl(request, response);
    }

    protected boolean isAlwaysUseDefaultTargetUrl() {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null) {
            return config.getBoolean(LOGIN_ALWAYS_USE_DEFAULT_SUCCESS_URL_KEY, super.isAlwaysUseDefaultTargetUrl());
        }
        return super.isAlwaysUseDefaultTargetUrl();
    }
}

