/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.CompositeFilter;

public class ConfigAwareCompositeFilter
extends CompositeFilter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAwareCompositeFilter.class);
    protected String configurationKey;

    public ConfigAwareCompositeFilter(String configurationKey) {
        this.configurationKey = configurationKey;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isEnabled()) {
            logger.debug("Filter is enabled, executing");
            super.doFilter(request, response, chain);
        } else {
            logger.debug("Filter is disabled, skipping execution");
            chain.doFilter(request, response);
        }
    }

    protected boolean isEnabled() {
        logger.debug("Checking if filter is with config key {}", (Object)this.configurationKey);
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        return siteConfig != null && siteConfig.getBoolean(this.configurationKey, false);
    }
}

