/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class ConfigAwareLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    public static final String LOGIN_FORM_URL_KEY = "security.login.formUrl";

    public ConfigAwareLoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey(LOGIN_FORM_URL_KEY)) {
            return siteConfig.getString(LOGIN_FORM_URL_KEY);
        }
        return super.getLoginFormUrl();
    }
}

