/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public abstract class ConfigAwarePreAuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    protected boolean alwaysEnabled = false;
    protected String enabledConfigKey;
    protected Class<? extends UserDetails> supportedPrincipalClass;

    public ConfigAwarePreAuthenticationFilter(String enabledConfigKey) {
        this.enabledConfigKey = enabledConfigKey;
    }

    public void setAlwaysEnabled(boolean alwaysEnabled) {
        this.alwaysEnabled = alwaysEnabled;
    }

    public void setSupportedPrincipalClass(Class<? extends UserDetails> supportedPrincipalClass) {
        this.supportedPrincipalClass = supportedPrincipalClass;
    }

    public boolean isEnabled() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        return this.alwaysEnabled || siteConfig != null && siteConfig.getBoolean(this.enabledConfigKey, false);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isEnabled()) {
            this.logger.debug((Object)"Filter is enabled, processing request");
            super.doFilter(request, response, chain);
        } else {
            this.logger.debug((Object)"Filter is disabled, skipping execution");
            chain.doFilter(request, response);
        }
    }

    protected boolean principalChanged(HttpServletRequest request, Authentication currentAuthentication) {
        this.logger.debug((Object)("Current authentication class: " + currentAuthentication.getClass().getSimpleName()));
        this.logger.debug((Object)("Current principal class:" + currentAuthentication.getPrincipal().getClass().getSimpleName()));
        if (currentAuthentication instanceof PreAuthenticatedAuthenticationToken && (this.supportedPrincipalClass == null || currentAuthentication.getPrincipal().getClass().equals(this.supportedPrincipalClass))) {
            this.logger.debug((Object)"Current authentication and principal are supported, continuing verification");
            return super.principalChanged(request, currentAuthentication);
        }
        this.logger.debug((Object)"Current authentication or principal class is not supported, skipping verification");
        return false;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

