/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class ConfigAwareSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    public static final String URL_RESTRICTION_KEY = "security.urlRestrictions.restriction";
    public static final String URL_RESTRICTION_URL_KEY = "url";
    public static final String URL_RESTRICTION_EXPRESSION_KEY = "expression";
    public static final String URL_RESTRICTIONS_CACHE_KEY = "urlRestrictions";
    protected CacheTemplate cacheTemplate;

    public ConfigAwareSecurityMetadataSource(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Callback callback = () -> {
            List restrictionsConfig;
            HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
            if (siteConfig != null && CollectionUtils.isNotEmpty((Collection)(restrictionsConfig = siteConfig.configurationsAt(URL_RESTRICTION_KEY)))) {
                LinkedHashMap<AntPathRequestMatcher, Set<SecurityConfig>> map = new LinkedHashMap<AntPathRequestMatcher, Set<SecurityConfig>>();
                for (HierarchicalConfiguration restrictionConfig : restrictionsConfig) {
                    String url = restrictionConfig.getString(URL_RESTRICTION_URL_KEY);
                    String expression = restrictionConfig.getString(URL_RESTRICTION_EXPRESSION_KEY);
                    if (!StringUtils.isNotEmpty((CharSequence)url) || !StringUtils.isNotEmpty((CharSequence)expression)) continue;
                    AntPathRequestMatcher matcher = new AntPathRequestMatcher(url);
                    map.put(matcher, Collections.singleton(new SecurityConfig(expression)));
                }
                return new ExpressionBasedFilterInvocationSecurityMetadataSource(map, (SecurityExpressionHandler)new DefaultWebSecurityExpressionHandler());
            }
            return new DefaultFilterInvocationSecurityMetadataSource(new LinkedHashMap());
        };
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            SecurityMetadataSource metadataSource = (SecurityMetadataSource)this.cacheTemplate.getObject(siteContext.getContext(), callback, new Object[]{URL_RESTRICTIONS_CACHE_KEY});
            return metadataSource.getAttributes(object);
        }
        return null;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }
}

