/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class DefaultSecurityFilterChain
implements SecurityFilterChain {
    protected boolean securityEnabled;
    protected List<AntPathRequestMatcher> urlsToExclude;
    protected List<Filter> filters;

    public DefaultSecurityFilterChain(boolean securityEnabled, String[] urlsToExclude, List<Filter> filters) {
        this.securityEnabled = securityEnabled;
        this.urlsToExclude = Stream.of(urlsToExclude).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        this.filters = filters;
    }

    public boolean matches(HttpServletRequest request) {
        return this.securityEnabled && this.urlsToExclude.stream().noneMatch(matcher -> matcher.matches(request));
    }

    public List<Filter> getFilters() {
        return this.filters;
    }
}

