/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.headers;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.engine.util.spring.security.ConfigAwarePreAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public abstract class AbstractHeadersAuthenticationFilter
extends ConfigAwarePreAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHeadersAuthenticationFilter.class);
    public static final String HEADERS_CONFIG_KEY = "security.headers";
    public static final String HEADERS_TOKEN_CONFIG_KEY = "security.headers.token";
    public static final String HEADERS_ATTRS_CONFIG_KEY = "security.headers.attributes";
    public static final String HEADERS_GROUPS_CONFIG_KEY = "security.headers.groups";
    public static final String HEADER_NAME_CONFIG_KEY = "security.headers.names";
    public static final String HEADERS_NAME_PREFIX_CONFIG_KEY = "security.headers.names.prefix";
    public static final String HEADERS_NAME_USERNAME_CONFIG_KEY = "security.headers.names.username";
    public static final String HEADERS_NAME_EMAIL_CONFIG_KEY = "security.headers.names.email";
    public static final String HEADERS_NAME_GROUPS_CONFIG_KEY = "security.headers.names.groups";
    public static final String HEADERS_NAME_TOKEN_CONFIG_KEY = "security.headers.names.token";
    public static final String NAME_CONFIG_KEY = "name";
    public static final String FIELD_CONFIG_KEY = "field";
    public static final String ROLE_CONFIG_KEY = "role";
    private String headerPrefix;
    private String usernameHeaderName;
    private String emailHeaderName;
    private String groupsHeaderName;
    private String tokenHeaderName;
    protected String defaultTokenValue;

    public AbstractHeadersAuthenticationFilter(String enabledConfigKey) {
        super(enabledConfigKey);
        this.setCheckForPrincipalChanges(true);
    }

    public void setHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    public void setUsernameHeaderName(String usernameHeaderName) {
        this.usernameHeaderName = usernameHeaderName;
    }

    public void setEmailHeaderName(String emailHeaderName) {
        this.emailHeaderName = emailHeaderName;
    }

    public void setGroupsHeaderName(String groupsHeaderName) {
        this.groupsHeaderName = groupsHeaderName;
    }

    public void setTokenHeaderName(String tokenHeaderName) {
        this.tokenHeaderName = tokenHeaderName;
    }

    public void setDefaultTokenValue(String defaultTokenValue) {
        this.defaultTokenValue = defaultTokenValue;
    }

    public String getHeaderPrefix() {
        return this.getConfigProperty(HEADERS_NAME_PREFIX_CONFIG_KEY, this.headerPrefix);
    }

    public String getUsernameHeaderName() {
        return this.getHeaderPrefix() + this.getConfigProperty(HEADERS_NAME_USERNAME_CONFIG_KEY, this.usernameHeaderName);
    }

    public String getEmailHeaderName() {
        return this.getHeaderPrefix() + this.getConfigProperty(HEADERS_NAME_EMAIL_CONFIG_KEY, this.emailHeaderName);
    }

    public String getGroupsHeaderName() {
        return this.getHeaderPrefix() + this.getConfigProperty(HEADERS_NAME_GROUPS_CONFIG_KEY, this.groupsHeaderName);
    }

    public String getTokenHeaderName() {
        return this.getHeaderPrefix() + this.getConfigProperty(HEADERS_NAME_TOKEN_CONFIG_KEY, this.tokenHeaderName);
    }

    protected abstract Object doGetPreAuthenticatedPrincipal(HttpServletRequest var1);

    @Override
    protected boolean principalChanged(HttpServletRequest request, Authentication currentAuthentication) {
        if (this.hasValidToken(request)) {
            return super.principalChanged(request, currentAuthentication);
        }
        return false;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (this.hasValidToken(request)) {
            return this.doGetPreAuthenticatedPrincipal(request);
        }
        return null;
    }

    protected String getTokenExpectedValue() {
        return this.getConfigProperty(HEADERS_TOKEN_CONFIG_KEY, this.defaultTokenValue);
    }

    protected boolean hasValidToken(HttpServletRequest request) {
        logger.debug("Checking security token from request headers");
        String tokenHeaderValue = request.getHeader(this.getTokenHeaderName());
        if (StringUtils.isEmpty((CharSequence)tokenHeaderValue)) {
            logger.debug("No security token found for request from '{}'", (Object)request.getRemoteAddr());
            return false;
        }
        if (!StringUtils.equals((CharSequence)tokenHeaderValue, (CharSequence)this.getTokenExpectedValue())) {
            logger.warn("Security token mismatch during authentication from '{}'", (Object)request.getRemoteAddr());
            return false;
        }
        return true;
    }

    protected String getConfigProperty(String key, String defaultValue) {
        HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
        if (config != null && config.containsKey(key)) {
            return config.getString(key);
        }
        return defaultValue;
    }
}

