/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.headers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.engine.util.spring.security.CustomUser;
import org.craftercms.engine.util.spring.security.headers.AbstractHeadersAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class StandaloneHeadersAuthenticationFilter
extends AbstractHeadersAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneHeadersAuthenticationFilter.class);
    public static final String STANDALONE_CONFIG_KEY = "security.headers.standalone";
    protected final CacheTemplate cacheTemplate;

    public StandaloneHeadersAuthenticationFilter(CacheTemplate cacheTemplate) {
        super(STANDALONE_CONFIG_KEY);
        this.setSupportedPrincipalClass(CustomUser.class);
        this.cacheTemplate = cacheTemplate;
    }

    @Override
    protected Object doGetPreAuthenticatedPrincipal(HttpServletRequest request) {
        String username = request.getHeader(this.getUsernameHeaderName());
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
            Collection<GrantedAuthority> authorities = this.getAuthorities(request, siteConfig);
            CustomUser user = new CustomUser(username, username, authorities);
            this.addAttributes(user, request, siteConfig);
            return user;
        }
        return null;
    }

    protected Collection<GrantedAuthority> getAuthorities(HttpServletRequest request, HierarchicalConfiguration config) {
        String groups = request.getHeader(this.getGroupsHeaderName());
        if (StringUtils.isNotEmpty((CharSequence)groups)) {
            Map roleMapping = (Map)this.cacheTemplate.getObject(SiteContext.getCurrent().getContext(), () -> {
                List groupsConfig = config.childConfigurationsAt("security.headers.groups");
                if (CollectionUtils.isNotEmpty((Collection)groupsConfig)) {
                    return groupsConfig.stream().collect(Collectors.toMap(groupConfig -> groupConfig.getString("name"), groupConfig -> groupConfig.getString("role")));
                }
                logger.debug("No groups mapping found in site configuration");
                return Collections.emptyMap();
            }, new Object[]{"role"});
            return Arrays.stream(groups.split(",")).filter(StringUtils::isNotEmpty).map(String::trim).map(group -> roleMapping.getOrDefault(group, group)).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        }
        logger.debug("Groups header '{}' was not present in the request", (Object)this.getGroupsHeaderName());
        return Collections.emptySet();
    }

    protected void addAttributes(CustomUser user, HttpServletRequest request, HierarchicalConfiguration config) {
        List attrsConfig = config.childConfigurationsAt("security.headers.attributes");
        if (CollectionUtils.isNotEmpty((Collection)attrsConfig)) {
            attrsConfig.forEach(attrConfig -> {
                String headerName = attrConfig.getString("name");
                String fieldName = attrConfig.getString("field");
                String fieldValue = request.getHeader(this.getHeaderPrefix() + headerName);
                if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
                    logger.debug("Adding attribute '{}' with value '{}'", (Object)fieldName, (Object)fieldValue);
                    user.setAttribute(fieldName, fieldValue);
                } else {
                    logger.debug("Expected header '{}' was not present in the request", (Object)headerName);
                }
            });
        }
    }
}

