/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.engine.util.spring.security.profile.ProfileUser;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class ProfileAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    protected TenantsResolver tenantsResolver;
    protected AuthenticationManager authenticationManager;

    public ProfileAuthenticationProvider(TenantsResolver tenantsResolver, AuthenticationManager authenticationManager) {
        this.tenantsResolver = tenantsResolver;
        this.authenticationManager = authenticationManager;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String[] tenants = this.getTenants();
        try {
            Authentication profileAuth = this.authenticationManager.authenticateUser(tenants, username, authentication.getCredentials().toString());
            return this.createPrincipal(profileAuth);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("Error authenticating user " + username, (Throwable)e);
        }
    }

    protected String[] getTenants() {
        Object[] tenants = this.tenantsResolver.getTenants();
        if (ArrayUtils.isEmpty((Object[])tenants)) {
            throw new AuthenticationServiceException("No tenants resolved for authentication");
        }
        return tenants;
    }

    protected ProfileUser createPrincipal(Authentication auth) {
        return new ProfileUser(auth);
    }
}

