/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.util.spring.security.headers.AbstractHeadersAuthenticationFilter;
import org.craftercms.engine.util.spring.security.profile.ProfileUser;
import org.craftercms.profile.api.AttributeDefinition;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHeadersAuthenticationFilter
extends AbstractHeadersAuthenticationFilter {
    private static final Logger logger = LoggerFactory.getLogger(ProfileHeadersAuthenticationFilter.class);
    protected final ProfileService profileService;
    protected final TenantService tenantService;
    protected final TenantsResolver tenantsResolver;

    public ProfileHeadersAuthenticationFilter(ProfileService profileService, TenantService tenantService, TenantsResolver tenantsResolver) {
        super(null);
        this.setAlwaysEnabled(true);
        this.setSupportedPrincipalClass(ProfileUser.class);
        this.profileService = profileService;
        this.tenantService = tenantService;
        this.tenantsResolver = tenantsResolver;
    }

    @Override
    protected Object doGetPreAuthenticatedPrincipal(HttpServletRequest request) {
        String username = request.getHeader(this.getUsernameHeaderName());
        String email = request.getHeader(this.getEmailHeaderName());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{username, email})) {
            try {
                String[] tenantNames = this.tenantsResolver.getTenants();
                Tenant tenant = this.getSsoEnabledTenant(tenantNames);
                if (tenant != null) {
                    Profile profile = this.profileService.getProfileByUsername(tenant.getName(), username, new String[0]);
                    if (profile == null) {
                        profile = this.createProfileWithSsoInfo(username, tenant, request);
                    }
                    return new ProfileUser(profile);
                }
                logger.warn("A SSO login was attempted, but none of the tenants [{}] is enabled for SSO", (Object)tenantNames);
            }
            catch (ProfileException e) {
                logger.error("Error processing headers authentication for '{}'", (Object)username, (Object)e);
            }
        }
        return null;
    }

    protected Tenant getSsoEnabledTenant(String[] tenantNames) throws ProfileException {
        for (String tenantName : tenantNames) {
            Tenant tenant = this.tenantService.getTenant(tenantName);
            if (tenant == null || !tenant.isSsoEnabled()) continue;
            return tenant;
        }
        return null;
    }

    protected Profile createProfileWithSsoInfo(String username, Tenant tenant, HttpServletRequest request) throws ProfileException {
        HashMap<String, String> attributes = null;
        List attributeDefinitions = tenant.getAttributeDefinitions();
        String email = request.getHeader(this.getEmailHeaderName());
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            String attributeName = attributeDefinition.getName();
            String attributeValue = request.getHeader(this.getHeaderPrefix() + attributeName);
            if (!StringUtils.isNotEmpty((CharSequence)attributeValue)) continue;
            if (attributes == null) {
                attributes = new HashMap<String, String>();
            }
            attributes.put(attributeName, attributeValue);
        }
        logger.info("Creating new profile with SSO info: username={}, email={}, tenant={}, attributes={}", new Object[]{username, email, tenant.getName(), attributes});
        return this.profileService.createProfile(tenant.getName(), username, null, email, true, null, attributes, null);
    }
}

