/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.engine.util.spring.security.profile.ProfileUser;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.exception.AuthenticationSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class ProfileLogoutHandler
implements LogoutHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProfileLogoutHandler.class);
    protected AuthenticationManager profileAuthenticationManager;

    public ProfileLogoutHandler(AuthenticationManager profileAuthenticationManager) {
        this.profileAuthenticationManager = profileAuthenticationManager;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication.getPrincipal() instanceof ProfileUser) {
            ProfileUser profileUser = (ProfileUser)((Object)authentication.getPrincipal());
            if (profileUser.authentication != null) {
                try {
                    this.profileAuthenticationManager.invalidateAuthentication(profileUser.authentication);
                }
                catch (AuthenticationSystemException e) {
                    logger.error("Error invalidating authentication for {}", (Object)profileUser.profile, (Object)e);
                }
            }
        }
    }
}

