/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.engine.util.spring.security.profile.ProfileUser;
import org.craftercms.engine.util.spring.security.profile.ProfileUserDetailsService;
import org.craftercms.profile.api.PersistentLogin;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.AuthenticationService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;

public class ProfileRememberMeServices
extends AbstractRememberMeServices {
    protected AuthenticationService authenticationService;

    public ProfileRememberMeServices(String key, UserDetailsService userDetailsService, AuthenticationService authenticationService) {
        super(key, userDetailsService);
        this.authenticationService = authenticationService;
    }

    protected void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        ProfileUser profileUser = (ProfileUser)((Object)successfulAuthentication.getPrincipal());
        try {
            PersistentLogin persistentLogin = this.authenticationService.createPersistentLogin(profileUser.getProfile().getId().toHexString());
            this.setCookie(new String[]{persistentLogin.getId(), persistentLogin.getToken()}, this.getTokenValiditySeconds(), request, response);
        }
        catch (ProfileException e) {
            throw new RememberMeAuthenticationException("Error creating persistent login for " + profileUser.getUsername(), (Throwable)e);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        String cookie = this.extractRememberMeCookie(request);
        if (authentication != null && StringUtils.isNotEmpty((CharSequence)cookie)) {
            String persistentLoginId = this.decodeCookie(cookie)[0];
            try {
                this.authenticationService.deletePersistentLogin(persistentLoginId);
            }
            catch (ProfileException e) {
                throw new RememberMeAuthenticationException("Error deleting persistent login " + persistentLoginId, (Throwable)e);
            }
        }
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) throws RememberMeAuthenticationException, UsernameNotFoundException {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        String presentedId = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        try {
            PersistentLogin persistentLogin = this.authenticationService.getPersistentLogin(presentedId);
            if (persistentLogin == null) {
                throw new RememberMeAuthenticationException("No persistent token found for id: " + presentedId);
            }
            if (!presentedToken.equals(persistentLogin.getToken())) {
                this.authenticationService.deletePersistentLogin(presentedId);
                throw new CookieTheftException("Invalid remember-me token (id/token) mismatch. Implies previous cookie theft attack.");
            }
            if (persistentLogin.getTimestamp().getTime() + (long)this.getTokenValiditySeconds() * 1000L < System.currentTimeMillis()) {
                throw new RememberMeAuthenticationException("Remember-me login has expired");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Refreshing persistent login token for profile '" + persistentLogin.getProfileId() + "', id '" + persistentLogin.getId() + "'"));
            }
            persistentLogin = this.authenticationService.refreshPersistentLoginToken(presentedId);
            this.setCookie(new String[]{persistentLogin.getId(), persistentLogin.getToken()}, this.getTokenValiditySeconds(), request, response);
            return ((ProfileUserDetailsService)this.getUserDetailsService()).loadUserById(persistentLogin.getProfileId());
        }
        catch (ProfileException e) {
            throw new RememberMeAuthenticationException("Error validating persistent login " + presentedId, (Throwable)e);
        }
    }
}

