/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.craftercms.engine.util.spring.security.CustomUser;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ProfileUser
extends CustomUser {
    protected Authentication authentication;
    protected Profile profile;

    public ProfileUser(Authentication auth) {
        this(auth.getProfile());
        this.authentication = auth;
    }

    public ProfileUser(Profile profile) {
        super(profile.getUsername(), "N/A", profile.isEnabled(), true, true, true, profile.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
        this.profile = profile;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)this.profile.getAttribute(name);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.profile.setAttributes(attributes);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.profile.setAttribute(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.profile.getAttributes();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileUser)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProfileUser details = (ProfileUser)((Object)o);
        return Objects.equals(this.profile, details.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.profile);
    }
}

