/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.profile;

import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.engine.util.spring.security.profile.ProfileUser;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ProfileUserDetailsService
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(ProfileUserDetailsService.class);
    protected TenantsResolver tenantsResolver;
    protected ProfileService profileService;

    public ProfileUserDetailsService(TenantsResolver tenantsResolver, ProfileService profileService) {
        this.tenantsResolver = tenantsResolver;
        this.profileService = profileService;
    }

    public UserDetails loadUserById(String id) {
        try {
            Profile profile = this.profileService.getProfile(id, new String[0]);
            return new ProfileUser(profile);
        }
        catch (ProfileException e) {
            logger.debug("Profile not found for id '{}'", (Object)id);
            return null;
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Object[] tenants = this.tenantsResolver.getTenants();
        if (ArrayUtils.isEmpty((Object[])tenants)) {
            throw new IllegalStateException("No tenants resolved for authentication");
        }
        for (Object tenant : tenants) {
            try {
                Profile profile = this.profileService.getProfileByUsername((String)tenant, username, new String[0]);
                return new ProfileUser(profile);
            }
            catch (ProfileException e) {
                logger.debug("Profile not found for '{}' in tenant '{}', will try next tenant", (Object)username, tenant);
            }
        }
        logger.error("Profile not found for '{}' in any tenant", (Object)username);
        return null;
    }
}

