/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.KeyManager;

public class CacheAwarePKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    private static final Logger logger = LoggerFactory.getLogger(CacheAwarePKIXValidationInformationResolver.class);
    protected CacheTemplate cacheTemplate;
    protected KeyManager keyManager;
    protected Set<String> trustedNames;
    protected Set<String> trustedKeys;

    public CacheAwarePKIXValidationInformationResolver(CacheTemplate cacheTemplate, KeyManager keyManager, Set<String> trustedNames, Set<String> trustedKeys) {
        this.cacheTemplate = cacheTemplate;
        this.keyManager = keyManager;
        this.trustedNames = trustedNames;
        this.trustedKeys = trustedKeys;
    }

    protected List<PKIXValidationInformation> getInfo() {
        return (List)this.cacheTemplate.getObject(SiteContext.getCurrent().getContext(), () -> {
            if (this.trustedKeys == null) {
                this.trustedKeys = this.keyManager.getAvailableCredentials();
            }
            LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
            for (String key : this.trustedKeys) {
                logger.debug("Adding PKIX trust anchor {} for metadata verification", (Object)key);
                X509Certificate certificate = this.keyManager.getCertificate(key);
                if (certificate != null) {
                    certificates.add(certificate);
                    continue;
                }
                logger.warn("Cannot construct PKIX trust anchor for key with alias {}, key isn't included in the keystore", (Object)key);
            }
            LinkedList<BasicPKIXValidationInformation> info = new LinkedList<BasicPKIXValidationInformation>();
            info.add(new BasicPKIXValidationInformation(certificates, null, Integer.valueOf(4)));
            return info;
        }, new Object[]{"PKIXInfo"});
    }

    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws UnsupportedOperationException {
        HashSet<String> temp = new HashSet<String>(this.trustedNames);
        EntityIDCriteria entityIDCriteria = (EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class);
        if (entityIDCriteria != null) {
            temp.add(entityIDCriteria.getEntityID());
        }
        return temp;
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    public Iterable<PKIXValidationInformation> resolve(CriteriaSet criteria) {
        return this.getInfo();
    }

    public PKIXValidationInformation resolveSingle(CriteriaSet criteria) {
        List<PKIXValidationInformation> pkixInfo = this.getInfo();
        return !pkixInfo.isEmpty() ? pkixInfo.get(0) : null;
    }
}

