/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.core.service.Content;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.KeyManager;

public class ConfigAwareJKSKeyManager
implements KeyManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAwareJKSKeyManager.class);
    public static final String KEYSTORE_CACHE_KEY = "saml2.keystore";
    public static final String CREDS_RESOLVER_CACHE_KEY = "saml2.credentialsResolver";
    protected SiteItemService siteItemService;
    protected CacheTemplate cacheTemplate;

    public ConfigAwareJKSKeyManager(SiteItemService siteItemService, CacheTemplate cacheTemplate) {
        this.siteItemService = siteItemService;
        this.cacheTemplate = cacheTemplate;
    }

    protected KeyStore getKeyStore() {
        return (KeyStore)this.cacheTemplate.getObject(SiteContext.getCurrent().getContext(), () -> {
            HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
            if (siteConfig != null) {
                String keystorePath = siteConfig.getString("security.saml2.keystore.path", "/config/engine/saml2/keystore.jks");
                String keystorePass = siteConfig.getString("security.saml2.keystore.password");
                Content content = this.siteItemService.getRawContent(keystorePath);
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(content.getInputStream(), keystorePass == null ? null : keystorePass.toCharArray());
                    return keyStore;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new SAMLRuntimeException("Error loading keystore", e);
                }
            }
            throw new SAMLRuntimeException("Invalid configuration for SAML2 keystore");
        }, new Object[]{KEYSTORE_CACHE_KEY});
    }

    protected CredentialResolver getCredentialResolver() {
        return (CredentialResolver)this.cacheTemplate.getObject(SiteContext.getCurrent().getContext(), () -> {
            List credentials;
            HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
            if (siteConfig != null && CollectionUtils.isNotEmpty((Collection)(credentials = siteConfig.configurationsAt("security.saml2.keystore.credentials.credential")))) {
                Map<String, String> passwords = credentials.stream().collect(Collectors.toMap(credential -> credential.getString("name"), credential -> credential.getString("password")));
                return new KeyStoreCredentialResolver(this.getKeyStore(), passwords);
            }
            throw new SAMLRuntimeException("Invalid configuration for SAML2 keystore");
        }, new Object[]{CREDS_RESOLVER_CACHE_KEY});
    }

    public Credential getCredential(String keyName) {
        if (keyName == null) {
            keyName = this.getDefaultCredentialName();
        }
        try {
            CriteriaSet cs = new CriteriaSet();
            EntityIDCriteria criteria = new EntityIDCriteria(keyName);
            cs.add((Object)criteria);
            return this.resolveSingle(cs);
        }
        catch (SecurityException e) {
            throw new SAMLRuntimeException("Can't obtain SP signing key", (Exception)((Object)e));
        }
    }

    public Credential getDefaultCredential() {
        return this.getCredential(null);
    }

    public String getDefaultCredentialName() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey("security.saml2.keystore.defaultCredential")) {
            return siteConfig.getString("security.saml2.keystore.defaultCredential");
        }
        return null;
    }

    public Set<String> getAvailableCredentials() {
        try {
            return new HashSet<String>(Collections.list(this.getKeyStore().aliases()));
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to load aliases from keyStore", e);
        }
    }

    public X509Certificate getCertificate(String alias) {
        if (alias == null || alias.length() == 0) {
            return null;
        }
        try {
            return (X509Certificate)this.getKeyStore().getCertificate(alias);
        }
        catch (Exception e) {
            logger.error("Error loading certificate for alias '{}'", (Object)alias, (Object)e);
            return null;
        }
    }

    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws SecurityException {
        return this.getCredentialResolver().resolve((Object)criteriaSet);
    }

    public Credential resolveSingle(CriteriaSet criteriaSet) throws SecurityException {
        return (Credential)this.getCredentialResolver().resolveSingle((Object)criteriaSet);
    }
}

