/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.engine.util.spring.security.saml2.CacheAwarePKIXValidationInformationResolver;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataManager;

public class ConfigAwareMetadataManager
extends MetadataManager {
    protected CacheTemplate cacheTemplate;

    public ConfigAwareMetadataManager(List<MetadataProvider> providers, CacheTemplate cacheTemplate) throws MetadataProviderException {
        super(providers);
        this.cacheTemplate = cacheTemplate;
        this.setRefreshCheckInterval(-1L);
    }

    protected PKIXValidationInformationResolver getPKIXResolver(MetadataProvider provider, Set<String> trustedKeys, Set<String> trustedNames) {
        return new CacheAwarePKIXValidationInformationResolver(this.cacheTemplate, this.keyManager, trustedNames, trustedKeys);
    }

    protected void initializeProviderData(ExtendedMetadataDelegate provider) {
    }

    public String getDefaultIDP() throws MetadataProviderException {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey("security.saml2.identityProviderName")) {
            return siteConfig.getString("security.saml2.identityProviderName");
        }
        return super.getDefaultIDP();
    }

    public String getHostedSPName() {
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        if (siteConfig != null && siteConfig.containsKey("security.saml2.serviceProviderName")) {
            return siteConfig.getString("security.saml2.serviceProviderName");
        }
        return super.getHostedSPName();
    }
}

