/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import java.io.IOException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.core.service.Content;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.util.ConfigUtils;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;

public class ConfigAwareResourceMetadataProvider
extends AbstractObservableMetadataProvider {
    protected String pathConfigKey;
    protected String pathDefaultValue;
    protected SiteItemService siteItemService;

    public ConfigAwareResourceMetadataProvider(String pathConfigKey, SiteItemService siteItemService) {
        this(pathConfigKey, null, siteItemService);
    }

    public ConfigAwareResourceMetadataProvider(String pathConfigKey, String pathDefaultValue, SiteItemService siteItemService) {
        this.pathConfigKey = pathConfigKey;
        this.pathDefaultValue = pathDefaultValue;
        this.siteItemService = siteItemService;
    }

    protected XMLObject doGetMetadata() throws MetadataProviderException {
        Content content;
        HierarchicalConfiguration siteConfig = ConfigUtils.getCurrentConfig();
        String path = this.pathDefaultValue;
        if (siteConfig != null && siteConfig.containsKey(this.pathConfigKey)) {
            path = siteConfig.getString(this.pathConfigKey);
        }
        if ((content = this.siteItemService.getRawContent(path)) == null) {
            throw new MetadataProviderException("Descriptor not found at path " + path);
        }
        try {
            return this.unmarshallMetadata(content.getInputStream());
        }
        catch (IOException | UnmarshallingException e) {
            throw new MetadataProviderException("Error reading descriptor file from " + path, (Exception)e);
        }
    }
}

