/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.engine.util.spring.security.CustomUser;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLCredential;

public class ConfigAwareSAMLAuthenticationProvider
extends SAMLAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigAwareSAMLAuthenticationProvider.class);
    private static final String CONFIG_CACHE_KEY = "saml2.config";
    protected CacheTemplate cacheTemplate;

    public ConfigAwareSAMLAuthenticationProvider(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    protected SAMLConfig getConfig(HierarchicalConfiguration siteConfig) {
        SiteContext siteContext = SiteContext.getCurrent();
        return (SAMLConfig)this.cacheTemplate.getObject(siteContext.getContext(), () -> {
            List mappings;
            SAMLConfig samlConfig = new SAMLConfig();
            samlConfig.roleElementName = siteConfig.getString("security.saml2.role.key", "Role");
            List attributes = siteConfig.configurationsAt("security.saml2.attributes.mappings.mapping");
            if (CollectionUtils.isNotEmpty((Collection)attributes)) {
                samlConfig.attributeMapping = new HashMap<String, String>();
                attributes.forEach(mapping -> samlConfig.attributeMapping.put(mapping.getString("name"), mapping.getString("attribute")));
            }
            if (CollectionUtils.isNotEmpty((Collection)(mappings = siteConfig.configurationsAt("security.saml2.role.mappings.mapping")))) {
                samlConfig.roleMapping = new HashMap<String, String>();
                mappings.forEach(mapping -> samlConfig.roleMapping.put(mapping.getString("name"), mapping.getString("role")));
            }
            return samlConfig;
        }, new Object[]{CONFIG_CACHE_KEY});
    }

    protected Object getPrincipal(SAMLCredential credential, Object userDetail) {
        if (userDetail != null) {
            return super.getPrincipal(credential, userDetail);
        }
        SAMLConfig samlConfig = this.getConfig(ConfigUtils.getCurrentConfig());
        CustomUser user = new CustomUser(credential.getNameID().getValue(), "", Collections.emptyList());
        samlConfig.attributeMapping.forEach((name, mapping) -> credential.getAttributes().stream().filter(attr -> attr.getName().equals(name)).findFirst().ifPresent(attribute -> {
            String finalName = StringUtils.isEmpty((CharSequence)mapping) ? name : mapping;
            logger.debug("Mapping incoming SAML attribute '{}' to user attribute '{}'", name, (Object)finalName);
            attribute.getAttributeValues().forEach(value -> user.setAttribute(finalName, this.attributeValueAsString((XMLObject)value)));
        }));
        return user;
    }

    protected Collection<? extends GrantedAuthority> getEntitlements(SAMLCredential credential, Object userDetail) {
        if (userDetail != null) {
            return super.getEntitlements(credential, userDetail);
        }
        SAMLConfig samlConfig = this.getConfig(ConfigUtils.getCurrentConfig());
        LinkedList authorities = new LinkedList();
        credential.getAttributes().stream().filter(attr -> attr.getName().equals(samlConfig.roleElementName)).findFirst().ifPresent(attribute -> {
            logger.debug("Found SAML role attribute: '{}'. Mapping role values...", (Object)samlConfig.roleElementName);
            attribute.getAttributeValues().forEach(value -> {
                String inputValue = this.attributeValueAsString((XMLObject)value);
                String outputValue = samlConfig.roleMapping.getOrDefault(inputValue, inputValue);
                logger.debug("Mapping original role value '{}' to '{}'", (Object)inputValue, (Object)outputValue);
                authorities.add(new SimpleGrantedAuthority(outputValue));
            });
        });
        return authorities;
    }

    protected String attributeValueAsString(XMLObject attributeValue) {
        if (attributeValue != null) {
            if (attributeValue instanceof XSString) {
                return ((XSString)attributeValue).getValue();
            }
            if (attributeValue instanceof XSAny) {
                return ((XSAny)attributeValue).getTextContent();
            }
            return attributeValue.toString();
        }
        return null;
    }

    protected static class SAMLConfig {
        protected String roleElementName;
        protected Map<String, String> attributeMapping = Collections.emptyMap();
        protected Map<String, String> roleMapping = Collections.emptyMap();

        protected SAMLConfig() {
        }
    }
}

