/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.saml2;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.service.context.SiteContext;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;

public class DelegatingSAMLContextProvider
implements SAMLContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingSAMLContextProvider.class);
    protected SAMLContextProvider defaultProvider;
    protected SAMLContextProvider proxyProvider;

    public DelegatingSAMLContextProvider(SAMLContextProvider defaultProvider, SAMLContextProvider proxyProvider) {
        this.defaultProvider = defaultProvider;
        this.proxyProvider = proxyProvider;
    }

    protected SAMLContextProvider getDelegate() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext == null) {
            throw new IllegalStateException("Could not resolve site context for request");
        }
        HierarchicalConfiguration config = siteContext.getConfig();
        if (config.getBoolean("security.saml2.reverseProxy", false)) {
            logger.debug("Using reverse proxy context provider for site {}", (Object)siteContext.getSiteName());
            return this.proxyProvider;
        }
        logger.debug("Using default context provider for site {}", (Object)siteContext.getSiteName());
        return this.defaultProvider;
    }

    public SAMLMessageContext getLocalEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        return this.getDelegate().getLocalEntity(request, response);
    }

    public SAMLMessageContext getLocalAndPeerEntity(HttpServletRequest request, HttpServletResponse response) throws MetadataProviderException {
        return this.getDelegate().getLocalAndPeerEntity(request, response);
    }
}

