/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.security.targeting;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.MapUtils;
import org.bson.types.ObjectId;
import org.craftercms.engine.util.spring.security.ConfigAwarePreAuthenticationFilter;
import org.craftercms.engine.util.spring.security.targeting.TargetingAuthentication;
import org.craftercms.engine.util.spring.security.targeting.TargetingUser;
import org.craftercms.profile.api.Profile;

public class TargetingPreAuthenticatedFilter
extends ConfigAwarePreAuthenticationFilter {
    public TargetingPreAuthenticatedFilter() {
        super(null);
        this.setAlwaysEnabled(true);
        this.setSupportedPrincipalClass(TargetingUser.class);
        this.setCheckForPrincipalChanges(true);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Map attributes;
        HttpSession session = request.getSession();
        if (session != null && MapUtils.isNotEmpty((Map)(attributes = (Map)session.getAttribute("_cr_profile_state")))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Non-anonymous persona set: " + attributes));
            }
            Profile profile = new Profile();
            profile.setId(new ObjectId((String)attributes.get("id")));
            profile.setUsername("preview");
            profile.setEnabled(true);
            profile.setCreatedOn(new Date());
            profile.setLastModified(new Date());
            profile.setTenant("preview");
            String rolesStr = (String)attributes.get("roles");
            if (rolesStr != null) {
                String[] roles = rolesStr.split(",");
                profile.getRoles().addAll(Arrays.asList(roles));
            }
            HashMap customAttributes = new HashMap(attributes);
            customAttributes.remove("id");
            customAttributes.remove("username");
            customAttributes.remove("roles");
            profile.setAttributes(customAttributes);
            return new TargetingUser(new TargetingAuthentication(profile));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No persona set. Trying to resolve authentication normally");
        }
        return null;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

