/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util.spring.social;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.engine.util.config.ConfigurationParser;
import org.craftercms.engine.util.config.impl.FacebookConnectionFactoryConfigParser;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.ConnectionFactoryRegistry;

public class ConfigAwareConnectionFactoryLocator
implements ConnectionFactoryLocator {
    public static final String SOCIAL_CONNECTIONS_KEY = "socialConnections";
    public static final String CONNECTION_FACTORY_LOCATOR_CACHE_KEY = "connectionFactoryLocator";
    protected ConnectionFactoryLocator defaultLocator;
    protected CacheTemplate cacheTemplate;
    protected List<ConfigurationParser<?>> configParsers = new ArrayList(1);

    public ConfigAwareConnectionFactoryLocator() {
        this.configParsers.add(new FacebookConnectionFactoryConfigParser());
    }

    @Required
    public void setDefaultLocator(ConnectionFactoryLocator defaultLocator) {
        this.defaultLocator = defaultLocator;
    }

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setConfigParsers(List<ConfigurationParser<?>> configParsers) {
        this.configParsers = configParsers;
    }

    public ConnectionFactory<?> getConnectionFactory(String providerId) {
        return this.getCurrentConnectionFactoryLocator().getConnectionFactory(providerId);
    }

    public <A> ConnectionFactory<A> getConnectionFactory(Class<A> apiType) {
        return this.getCurrentConnectionFactoryLocator().getConnectionFactory(apiType);
    }

    public Set<String> registeredProviderIds() {
        return this.getCurrentConnectionFactoryLocator().registeredProviderIds();
    }

    protected ConnectionFactoryLocator getCurrentConnectionFactoryLocator() {
        Callback<ConnectionFactoryLocator> callback = new Callback<ConnectionFactoryLocator>(){

            public ConnectionFactoryLocator execute() {
                HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
                ConnectionFactoryRegistry registry = null;
                if (config != null) {
                    try {
                        HierarchicalConfiguration socialConnectionsConfig = config.configurationAt(ConfigAwareConnectionFactoryLocator.SOCIAL_CONNECTIONS_KEY);
                        for (ConfigurationParser<?> parser : ConfigAwareConnectionFactoryLocator.this.configParsers) {
                            ConnectionFactory factory = (ConnectionFactory)parser.parse(socialConnectionsConfig);
                            if (factory == null) continue;
                            if (registry == null) {
                                registry = new ConnectionFactoryRegistry();
                            }
                            registry.addConnectionFactory(factory);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (registry != null) {
                    return registry;
                }
                return ConfigAwareConnectionFactoryLocator.this.defaultLocator;
            }
        };
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return (ConnectionFactoryLocator)this.cacheTemplate.getObject(siteContext.getContext(), (Callback)callback, new Object[]{CONNECTION_FACTORY_LOCATOR_CACHE_KEY});
        }
        return this.defaultLocator;
    }
}

